// precompiled header, should always be the first include
#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources/clAudioSourceFactory.h"
#include "AudioStack/clGeniviAudioSource.h"

#include <sstream>

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clAudioSourceFactory.cpp.trc.h"
#endif

namespace AudioStack
{

bpstl::map<SourceID, clAudioSource*> clAudioSourceFactory::audioSourceMap;
tU8 clAudioSourceFactory::SourceObjectCounter = 0;


tVoid clAudioSourceFactory::resetAudioSources()
{
     // Get Enumerator of ClientHandlers
     bpstl::map<SourceID, clAudioSource*>::const_iterator tIterator;
     // iterate through Vector
     for ( tIterator  = audioSourceMap.begin();
           tIterator.operator!=( audioSourceMap.end());
           ++tIterator)
     {
        if((*tIterator).second!=NULL)
        {
           (*tIterator).second->vReset();
        }
     }
}

tVoid clAudioSourceFactory::removeAudioSources(SourceID srcID)
{
   //Search for source
   bpstl::map<SourceID, clAudioSource*>::const_iterator tIterator;
   tIterator = audioSourceMap.find(srcID);
   //if we found the corresponding source object
   if (tIterator.operator!=(audioSourceMap.end()))
   {
      ETG_TRACE_USR3((" AudioSourcefactory: delete AudioSource: SourceClass: %d subID %#x(%d)"
            ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(srcID.enSourceClass))
            , srcID.u16SubSource
            , srcID.u16SubSource));
      delete (*tIterator).second;
      (*tIterator).second = NULL;
      audioSourceMap.erase(srcID);
   }
}

tVoid clAudioSourceFactory::Init()
{

   // Create StaticSource Objects
   for(tU16 i = 0; i < static_cast<AudioSources::enAudioSources>(AudioSources::LAST); ++i)
   {
      if(clStackRules::rules[i].sourceRegistration == clStackRules::registerStatic)
      {
         ETG_TRACE_USR3((" AudioSourcefactory: Create static AudioSource: SourceClass: %d "
                ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(clStackRules::rules[i].src))));
         //Do register only for those sources that are configured for static availability
         clAudioSource* pAudSrc = clAudioSourceFactory::getAudioSource((clStackRules::rules[i].src),0);
         if(pAudSrc != NULL)
         {
            pAudSrc->vSourceAvailablilityChange(clAudioSource::available,clAudioSource::samemedia);
         }
      }
   }
}

tVoid clAudioSourceFactory::ListSources()
{
   ETG_TRACE_ERR((" AudioSourceFactory instantiated Sources: "));
   bpstl::map<SourceID, clAudioSource*>::const_iterator tIterator;

   for ( tIterator  = audioSourceMap.begin();
         tIterator.operator!=( audioSourceMap.end());
         ++tIterator)
   {
      if((*tIterator).second != NULL)
      {

         (*tIterator).second->vPrint();
      }
   }
}
clAudioSource* clAudioSourceFactory::getAudioSource(AudioSources::enAudioSources audioSourceClass, tU8 subSourceID)
{
   return getAudioSource(SourceID(audioSourceClass,subSourceID ));
}

clAudioSource* clAudioSourceFactory::getAudioSource(SourceID audioSource)
{
  //clAudioSource* pcoRetVal = NULL;
  // Map virtualSources to logicals, e.g. map PresetBanks of Tuner to TunerSource
  // AudioSources::enAudioSources logicalSource = mapVirtualToLogicalSource(audioSource);

  //Search for source
  bpstl::map<SourceID, clAudioSource*>::const_iterator tIterator;
  tIterator = audioSourceMap.find(audioSource);
  //if we found the corresponding source object
  if (tIterator.operator!=(audioSourceMap.end()))
  {
    return (*tIterator).second;
  }else{
    // else we have to create it...
    audioSourceMap[audioSource] = createAudioSourceObj(audioSource);
    return audioSourceMap[audioSource];
  }
}


AudioSources::enAudioSources clAudioSourceFactory::mapVirtualToLogicalSource(AudioSources::enAudioSources audioSource)
{
   switch(audioSource)
   {
      case AudioSources::SOURCE_MEDIA:
         audioSource = AudioSources::MEDIA_DB_PLAYER;
         break;
      default:
         break;
   }
   return audioSource;
}

clAudioSource* clAudioSourceFactory::getAvailableAudioSource()
{
   bpstl::map<SourceID, clAudioSource*>::iterator tIterator;
   // iterate through Vector
   for ( tIterator  = audioSourceMap.begin();
         tIterator.operator!=( audioSourceMap.end());
         ++tIterator)
   {
      if((*tIterator).first.enSourceClass != AudioSources::NONE)
      {
         if(((*tIterator).second != NULL) &&((*tIterator).second->enIsSourceAvailable()))
         {
            return (*tIterator).second;
         }
      }
   }
   return NULL;
}

clAudioSource* clAudioSourceFactory::getAvailableAudioSource(AudioSources::enAudioSources sourceClass)
{
   bpstl::map<SourceID, clAudioSource*>::iterator tIterator;
   // iterate through Vector
   for ( tIterator  = audioSourceMap.begin();
         tIterator.operator!=( audioSourceMap.end());
         ++tIterator)
   {
      if((*tIterator).first.enSourceClass == sourceClass)
      {
         if(((*tIterator).second != NULL) &&((*tIterator).second->enIsSourceAvailable()))
         {
            return (*tIterator).second;
         }
      }
   }
   return NULL;
}

clAudioSource* clAudioSourceFactory::createAudioSourceObj(SourceID audioSource)
{
  clAudioSource* pRetAudioSrcObj = NULL;
  ETG_TRACE_USR3((" AudioSourcefactory: Create AudioSource: SourceClass: %d subID %#x(%d)"
         ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(audioSource.enSourceClass))
         , audioSource.u16SubSource
         , audioSource.u16SubSource));

//  audioSource = mapVirtualToLogicalSource(audioSource);
//  ETG_TRACE_USR3((" AudioSourcefactory: AudioSource is mapped to source %d",\
//                    ETG_CENUM(AudioSources::enAudioSources, audioSource)));


  clStackRules::rules_t rule = clStackRules::rules[clStackRules::ruleIndex(audioSource)];

//  registerStatic,
//      registerDynamic,
//      registerNone

  if((rule.sourceRegistration == clStackRules::registerStatic )&&(audioSource.u16SubSource != 0 ))
  {
     ETG_TRACE_FATAL(("ERROR: createAudioSourceObj fails because SourceClass %d SubSource %d is configured for static registration. SubSource must be 0",
           audioSource.enSourceClass, audioSource.u16SubSource));
     return NULL;
  }
  // Create corresponding Object
  switch(rule.group)
  {
     case clStackRules::groupInternal:
        pRetAudioSrcObj = OSAL_NEW clAudioSource(audioSource);
        break;
     default:
        //       ++SourceObjectCounter;
        //       std::ostringstream s;
        //       s << "AudioSrcObj_" << SourceObjectCounter;
        pRetAudioSrcObj = OSAL_NEW clGeniviAudioSource(audioSource);
        //pRetAudioSrcObj = OSAL_NEW clAudioSource(s.str().c_str(), audioSource);
        break;
  }


  if(pRetAudioSrcObj != NULL)
  {
    //pRetAudioSrcObj->vSetTrace(m_poTrace);
     ETG_TRACE_USR3((" AudioSourcefactory: Instantiated AudioSource SourceClass: %d subID %#x(%d): %s"
         , ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(audioSource.enSourceClass))
         , audioSource.u16SubSource
         , audioSource.u16SubSource
         , pRetAudioSrcObj->pacGetName()));
  }
  return pRetAudioSrcObj;
}

//VVD need to check if source is Valid
tBool clAudioSourceFactory::isValidSourceClass(AudioSources::enAudioSources audioSource)
{

   // as long as we do not have stl container we'll iterate through array
  int i = 0;
  if(clStackRules::ruleIndex(audioSource) < 0)
  {
     ETG_TRACE_FATAL((" ERROR: requested Source class %d is not mapped to StackRule",\
                     ETG_CENUM(AudioSources::enAudioSources, audioSource)));
     return FALSE;
  }
  return TRUE;
}

clAudioSource* clAudioSourceFactory::isSourceInstantiated(SourceID srcId)
{
   //Search for source
    bpstl::map<SourceID, clAudioSource*>::const_iterator tIterator;
    tIterator = audioSourceMap.find(srcId);
    //if we found the corresponding source object
    if (tIterator.operator!=(audioSourceMap.end()))
    {
      return (*tIterator).second;
    }
    return NULL;
}


}

